.H 1 "Rtpi Window"
The Rtpi window establishes connections to local and remote debug agents,
and is the first window created when rtpi is started.
.H 2 "Rtpi Layout"
Each line lists the name of a local debug agent or a remote system.
Lines that start with `!' list the names of
agents implemented with local Unix processes along with any
command line arguments used to start them.
Other lines contain the Internet names of remote processors.
The lines are sorted alphabetically.
.P
If an attempt to open a debug server fails,
either because the local program could not be found,
or there was no response from a remote agent within 10 seconds,
a line of the form:
.DS I N
Can't open server_name
.DE
.P
is inserted into the window.
.H 2 "Rtpi Menu Bar"
.VL 8 1
.LI "help"
Open the Help window.
.LI "quit"
Quit the debugger and detach from all debug agents and processes.
A pop-up window will ask you to confirm this choice.
.LE
.H 2 "Rtpi Keyboard"
Syntax
.DS I N
!program [arg1 ...]
internet_name
.DE
.P
The Rtpi window's keyboard language accepts the names of local and
remote debug agents.
Entering an agent's name creates a new line in the window,
but does not open the communications channel.
To contact an agent, select its line and choose
the "open connection" entry in its line menu.
.P
If the entered line is in the format "!program [arg1 ...]" rtpi assumes
the debug agent is implemented with a local Unix process.
Program is the name of the executable file that is started when
the connection is opened.
The program may be anywhere on your PATH.
.P
Rtpi assumes that lines that do not start with `! contain the
Internet name of a remote processor running a debug agent.
When the target is opened,
a UDP/IP Ethernet connection is made with a server that must
be listening on UDP port number 2005 on the remote system.
Internet names may be found in the file /etc/hosts.
.P
To avoid typing in the names of the debug agents each time rtpi is started,
the RTCONNECTIONS environment variable may be used to place a list of
initial entries in the window.
RTCONNECTIONS should be set to a string and the names
of debug agents should be delimited with spaces.
For example, to place initial entries in the Rtpi window for 
the local debug agents dsimc and dspserver,
and the remote agent on the processor vme3,
execute the following Bourne shell commands before rtpi is started:
.DS I N
RTCONNECTIONS="!dsimc !dspserver vme3"
export RTCONNECTIONS
.DE
.H 2 "Rtpi Line Menus"
.VL 8 1
.LI "open connection"
.br
Open the connection to the server listed on the line.
If the line starts with `!', the rest of the line is assumed to be
the name of a Unix program that starts the debug agent,
along with any optional arguments.
Choosing the entry causes that program to be started and a
Unix domain socket is established for communications between the agent and rtpi.
.P
If the selected line does not start with `!', the line must
contain an Internet host name and a UDP/IP Ethernet connection
is established to a server that must already be running on that host.
.LE
.P
Once a connection has been established
the following automatic configuration operations occur in rtpi:
.AL 1
.LI
Rtpi determines how many processors are available through the agent.
.LI
If more than one processor is available,
the Processors window for that agent is opened.
The Processors window lists the names of the processors and the line
menus may be used to open them.
.LI
If only one processor is available
a window appropriate for that processor's type 
and operating system is opened.
From this window you may attach the debugger to
programs that are executing or down-load new programs. 
.LE
